' $INCLUDE: 'SBC.BI'
' $INCLUDE: 'SBCSYS.BI'
' $INCLUDE: 'SBMIDI.BI'


REM $DYNAMIC
CLEAR

CLS

PRINT "SBK Basic MIDI In Interface Example"

DIM midicode&, timestamp&, midibyte%
DIM userkey%, key$


IF (SBGETENV% = 0) THEN

    ' Check for Sound Blaster Card DSP
    IF ((SBCHKCRD% AND 4) = 4) THEN

        ' Scan for interrupt
        IF SBTSTINT% THEN

            ' start MIDI input
            CALL MIDISTIN

            ' Read MIDI Input from buffer
            DO
                ' Check for ESC key
                c$ = INKEY$

                IF (c$ <> "") THEN

                    userkey = ASC(c$)

                    IF userkey = 27 THEN
                        EXIT DO
                    ENDIF

                ENDIF

                ' Get MIDI code from buffer
                midicode& = MIDIGETI&

                IF (midicode& <> 0) THEN

                    ' MIDI byte
                    midibyte% = midicode& MOD 256

                    ' MIDI time stamp
                    timestamp& = CLNG((midicode& - CLNG(midibyte%)) / 256)

                    ' print data
                    PRINT "MIDI Byte : ";HEX$(midibyte%);TAB(16);" hex     ";
                    PRINT USING "Time Stamp : ######## msec"; timestamp&
              
                ENDIF

            LOOP

            ' Stop MIDI input
            CALL MIDISPIN

            ' Read the remaining codes in the buffer
            DO

                ' Get MIDI code from buffer
                midicode& = MIDIGETI&

                IF (midicode& <> 0) THEN

                    ' MIDI byte
                    midibyte% = midicode& MOD 256

                    ' MIDI time stamp
                    timestamp& = CLNG((midicode& - CLNG(midibyte%)) / 256)

                    ' print data
                    PRINT "MIDI Byte : ";HEX$(midibyte%);TAB(16);" hex     ";
                    PRINT USING "Time Stamp : ######## msec"; timestamp&
              
                ENDIF

            LOOP UNTIL (midicode& = 0)

        ELSE
            PRINT "Error on interrupt"
        ENDIF
    ELSE
        PRINT "Sound Blaster Card not found or wrong I/O setting"
    ENDIF
ELSE
    PRINT "BLASTER environment variable not set or incomplete or invalid"
END IF

END

